define(function () {

    var component = {
        inject: ["configuration"],
        components: {},
        data: function () {
            return {
                reRender: false,
                autoPlay: true
            };
        },
        watch: {
            items: function () {
                var _this = this;
                this.reRender = true;
                if (this.items.length === 1) {
                    this.autoPlay = false;
                }
                else {
                    this.autoPlay = true;
                }
                this.$nextTick(function () {
                    _this.reRender = false;
                });
            }
        }
    };

    component.originalTemplate = "corpViewModern.fullWidth";
    component.template = `
<wizdomWebpart data-v-86a26376
  :environmentInfo="environmentInfo"
  :chromeProperties="webpartProperties.chromeProperties"
  :title="'Corporate News' | translate"
  @titleChanged="webpartProperties.title = $event"
  @webpart-resize="webpartResize"
>
  <agile data-v-86a26376
    v-if="items.length && !reRender"
    :class="'toShowDots' + webpartProperties.numberOfNews"
    :autoplay="autoPlay"
    :fade="false"
    :speed="750"
    :autoplaySpeed="webpartProperties.rotation * 1000"
    :navButtons="false"
    :dots="true"
  >
    <div data-v-86a26376 v-for="item in items" :key="item.key" class="slide">
      <div data-v-86a26376 class="image" v-if="items">
        <div data-v-86a26376
          v-if="item.breaking && webpartProperties.breakingTag"
          class="breaking"
        >{{webpartProperties.breakingTagText}}</div>
        <a data-v-86a26376 class="linktext" target="_blank" :href="item.path">
          <div data-v-86a26376 class="image-container image" :style="getStyle(item)">
            <div data-v-86a26376 id="content" class="content">
              <tags data-v-86a26376 v-if="item.listOfTags" :tags="item.listOfTags" :sizenow="sizenow" ref="tags"></tags>
              <h2 data-v-86a26376 class="title" @click="testNav()">{{item.title}}</h2>
              <div data-v-86a26376 class="summary" v-html="item.summary.length > 0 ? item.summary : item.content"></div>
              <!-- <p data-v-86a26376 class="content-text" v-html="(item.summary.length>0 ? (item.summary.length>200 ? item.summary.substring(0,300) : item.summary) : (item.content.length > 300 ? item.content.substring(0, 300) + '...' : item.content))"></p> -->
              <div data-v-86a26376 class="timeago-view-container">
                <div data-v-86a26376 v-show="item.date" class="datetime">
                  <uiIconClock data-v-86a26376 />
                  <timeago data-v-86a26376 :since="item.date" locale="lang">></timeago>
                </div>
                <views data-v-86a26376 v-if="webpartProperties.showViewCount" :views="item.views"></views>
              </div>
            </div>
          </div>
        </a>
      </div>
    </div>
  </agile>
  <noItem data-v-86a26376
    v-if="!items.length && webpartProperties.contentPlaceholder"
    :title="contentPlaceholder.title"
    :theme="false"
    :illustration="'coffee'"
  ></noItem>
</wizdomWebpart>
`;
    component.styles = `
.agile {
  position: relative;
}
.agile--rtl .agile__actions, .agile--rtl .agile__dots, .agile--rtl .agile__slides, .agile--rtl .agile__track {
  -webkit-box-orient: horizontal;
  -webkit-box-direction: reverse;
  -ms-flex-direction: row-reverse;
  flex-direction: row-reverse;
}
.agile:active, .agile :active, .agile:focus, .agile :focus {
  outline: none;
}
.agile__list {
  display: block;
  overflow: hidden;
  position: relative;
  width: 100%;
}
.agile__track {
  -webkit-box-orient: horizontal;
  -webkit-box-direction: normal;
  -ms-flex-direction: row;
  flex-direction: row;
  -ms-flex-wrap: nowrap;
  flex-wrap: nowrap;
}
.agile__actions, .agile__track {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
}
.agile__actions {
  -webkit-box-pack: justify;
  -ms-flex-pack: justify;
  justify-content: space-between;
}
.agile__slides {
  -webkit-box-align: center;
  -ms-flex-align: center;
  align-items: center;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-orient: horizontal;
  -webkit-box-direction: normal;
  -ms-flex-direction: row;
  flex-direction: row;
  -webkit-box-flex: 1;
  -ms-flex-positive: 1;
  flex-grow: 1;
  -ms-flex-negative: 0;
  flex-shrink: 0;
  -ms-flex-wrap: nowrap;
  flex-wrap: nowrap;
  -webkit-box-pack: start;
  -ms-flex-pack: start;
  justify-content: flex-start;
}
.agile--disabled .agile__slides {
  display: block;
}
.agile__slide {
  display: block;
  -webkit-box-flex: 1;
  -ms-flex-positive: 1;
  flex-grow: 1;
  -ms-flex-negative: 0;
  flex-shrink: 0;
}
.agile--fade .agile__slide {
  opacity: 0;
  position: relative;
  z-index: 0;
}
.agile--fade .agile__slide--active {
  opacity: 1;
  z-index: 2;
}
.agile--fade .agile__slide--expiring {
  opacity: 1;
  -webkit-transition-duration: 0s;
  transition-duration: 0s;
  z-index: 1;
}
.agile__nav-button[disabled] {
  cursor: default;
}
.agile__dots {
  -webkit-box-align: center;
  -ms-flex-align: center;
  align-items: center;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  list-style: none;
  padding: 0;
  white-space: nowrap;
}
.agile__dot button {
  cursor: pointer;
  display: block;
  font-size: 0;
  line-height: 0;
}


div[data-v-86a26376] .agile__list {
  height: 300px;
}
div[data-v-86a26376] .slide {
  z-index: 3;
}
div[data-v-86a26376] .agile__slide--active {
  z-index: 4 !important;
}
div[data-v-86a26376] .tag-container .tag {
  color: #fff !important;
}
.toShowDots1[data-v-86a26376] .agile__dots {
  visibility: hidden;
}
div[data-v-86a26376] .agile__dots {
  top: -35px;
  align-items: center;
  display: -ms-flexbox;
  display: flex;
  -ms-flex-pack: center;
  justify-content: center;
  list-style: none;
  padding: 0;
  text-align: center;
  white-space: nowrap;
  bottom: 0;
  left: 50%;
  transform: translateX(-50%);
  position: relative;
  z-index: 2;
  justify-content: center;
}
div[data-v-86a26376] .agile__dot button {
  margin: 0 10px;
  padding: 0;
  background-color: #fff;
  border: none;
  border-radius: 50%;
  cursor: pointer;
  display: block;
  height: 10px;
  font-size: 0;
  line-height: 0;
  transition-duration: 0.3s;
  width: 10px;
}
div[data-v-86a26376] .agile__dot button:hover {
    background-color: black;
}
div[data-v-86a26376] .agile__dot--current button {
  background-color: #000;
}
.slide[data-v-86a26376] {
  background-position: center;
  background-size: cover;
  height: 500px;
}
.image[data-v-86a26376] {
  align-self: flex-start;
  z-index: 1;
  position: relative;
  -ms-flex-negative: 0;
  flex-shrink: 0;
  box-sizing: border-box;
}
.linktext[data-v-86a26376] {
  color: #fff;
  display: block;
}
.breaking[data-v-86a26376] {
  color: "[theme:white, default:#fff]";
  background-color: "[theme:accent, default:#0078d4]";
  position: absolute;
  top: 20px;
  left: 0;
  z-index: 2;
  text-align: center;
  padding: 5px 10px 5px 10px;
}
.datetime[data-v-86a26376] {
  float: left;
  padding-right: 15px;
}
.image-container[data-v-86a26376] {
  position: relative;
  height: 300px;
  background-color: "[theme:neutralLighterAlt, default:#eaeaea]";
  border: 1px solid "[theme:neutralLight, default:#eaeaea]";
  width: calc(100%);
}
.image-container .content[data-v-86a26376] {
    width: 100%;
    overflow: hidden;
    position: absolute;
    bottom: 0;
    padding-bottom: 40px;
    padding-left: 24px;
    padding-right: 24px;
    min-width: 220px;
}
.image-container h2[data-v-86a26376] {
    font-size: 21px;
}
.image-container h2.title[data-v-86a26376] {
      margin: 0;
      padding-top: 5px;
      width: 85%;
      display: block;
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
      font-weight: normal;
      line-height: 1.2;
}
.placeholder .image-container h2.title[data-v-86a26376] {
        color: "[theme: bodyText, default: #333333]";
}
.image-container .content-text[data-v-86a26376] {
    font-size: 14px;
    padding-bottom: 20px;
    max-width: 500px;
    color: #fff;
}
.summary[data-v-86a26376] {
  font-size: 14px;
  margin-top: 5px;
  line-height: 1.3em;
  height: 4em;
  overflow: hidden;
  margin-bottom: 20px;
  max-width: 85%;
  color: #fff;
}
.placeholder .summary[data-v-86a26376] {
    color: "[theme: bodyText, default: #333333]";
}


`;

    return component;

});
